import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesWarehouseChg分页参数 模型
 */
export interface MesWarehouseChgPageParams extends BasicPageParams {
  dataCode: string;

  applyId: string;

  dataName: string;

  dataDate: string;

  inUser: string;

  outUser: string;

  inStorage: string;

  outStorage: string;

  remark: string;
}

/**
 * @description: MesWarehouseChg分页返回值模型
 */
export interface MesWarehouseChgPageModel {
  id: string;

  dataCode: string;

  applyId: string;

  dataName: string;

  dataDate: string;

  inUser: string;

  outUser: string;

  inStorage: string;

  outStorage: string;

  remark: string;
}

/**
 * @description: MesWarehouseChg表类型
 */
export interface MesWarehouseChgModel {
  id: number;

  isSysNum: string;

  dataCode: string;

  dataName: string;

  dataDate: string;

  applyId: string;

  isApplyNum: number;

  inUser: string;

  outUser: string;

  inStorage: string;

  outStorage: string;

  dataFile: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesWarehouseChgDetailList?: MesWarehouseChgDetailModel;
}

/**
 * @description: MesWarehouseChgDetail表类型
 */
export interface MesWarehouseChgDetailModel {
  id: number;

  chgId: number;

  productNo: string;

  productName: string;

  productId: string;

  speModel: string;

  deType: string;

  unity: string;

  num: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesWarehouseChg分页返回值结构
 */
export type MesWarehouseChgPageResult = BasicFetchResult<MesWarehouseChgPageModel>;
